import React from "react";
import { NavLink } from "react-router-dom";

const Navigation = () => {
  const linkClass = "nav-link fw-bold";

  return (
    <nav className="navbar navbar-expand-lg navbar-light bg-dark bg-opacity-10">
      <div className="container-fluid">
        <a className="navbar-brand" href="#">
          {" "}
        </a>
        {/* Toggler Button */}
        <button
          className="navbar-toggler"
          type="button"
          data-bs-toggle="collapse"
          data-bs-target="#navbarNav"
          aria-controls="navbarNav"
          aria-expanded="false"
          aria-label="Toggle navigation"
        >
          <span className="navbar-toggler-icon"></span>
        </button>
        {/* Collapsible Menu */}
        <div className="collapse navbar-collapse" id="navbarNav">
          <ul className="navbar-nav mx-auto">
            <li className="nav-item">
              <NavLink
                to="/"
                className={({ isActive }) =>
                  `${linkClass} ${isActive ? "text-secondary" : "text-primary"}`
                }
              >
                Journal
              </NavLink>
            </li>
            <li className="nav-item">
              <NavLink
                to="/documents"
                className={({ isActive }) =>
                  `${linkClass} ${isActive ? "text-secondary" : "text-primary"}`
                }
              >
                Documents
              </NavLink>
            </li>
            <li className="nav-item">
              <NavLink
                to="/encrypt"
                className={({ isActive }) =>
                  `${linkClass} ${isActive ? "text-secondary" : "text-primary"}`
                }
              >
                Encrypt
              </NavLink>
            </li>
            <li className="nav-item">
              <NavLink
                to="/notes"
                className={({ isActive }) =>
                  `${linkClass} ${isActive ? "text-secondary" : "text-primary"}`
                }
              >
                Notes
              </NavLink>
            </li>
          </ul>
        </div>
      </div>
    </nav>
  );
};

export default Navigation;
